<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\DoctorController;
use App\Http\Controllers\PharmacistController;
use App\Http\Controllers\PrescriptionController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect('/login');
});

Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Doctor Registration
Route::get('/doctor/register', [\App\Http\Controllers\DoctorRegistrationController::class, 'showRegistration'])->name('doctor.register');
Route::post('/doctor/register', [\App\Http\Controllers\DoctorRegistrationController::class, 'register']);

// Patient Registration (if enabled)
Route::get('/patient/register', [\App\Http\Controllers\PatientRegistrationController::class, 'showRegistration'])->name('patient.register');
Route::post('/patient/register', [\App\Http\Controllers\PatientRegistrationController::class, 'register']);

// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    Route::get('/doctors', [AdminController::class, 'doctors'])->name('doctors');
    Route::get('/doctors/create', [AdminController::class, 'createDoctor'])->name('doctors.create');
    Route::post('/doctors', [AdminController::class, 'storeDoctor'])->name('doctors.store');
    Route::get('/doctors/{id}', [AdminController::class, 'showDoctor'])->name('doctors.show');
    Route::get('/doctors/{id}/availability', [AdminController::class, 'viewDoctorAvailability'])->name('doctors.availability');
    Route::get('/doctors/{id}/edit', [AdminController::class, 'editDoctor'])->name('doctors.edit');
    Route::put('/doctors/{id}', [AdminController::class, 'updateDoctor'])->name('doctors.update');
    Route::post('/doctors/{id}/verify', [AdminController::class, 'verifyDoctor'])->name('doctors.verify');
    Route::post('/doctors/{id}/toggle-status', [AdminController::class, 'toggleDoctorStatus'])->name('doctors.toggle-status');
    Route::delete('/doctors/{id}', [AdminController::class, 'deleteDoctor'])->name('doctors.delete');
    
    Route::get('/branches', [AdminController::class, 'branches'])->name('branches');
    Route::post('/branches', [AdminController::class, 'storeBranch'])->name('branches.store');
    Route::put('/branches/{id}', [AdminController::class, 'updateBranch'])->name('branches.update');
    Route::delete('/branches/{id}', [AdminController::class, 'deleteBranch'])->name('branches.delete');
    
    Route::get('/users', [\App\Http\Controllers\AdminUserController::class, 'index'])->name('users');
    Route::get('/users/create', [\App\Http\Controllers\AdminUserController::class, 'create'])->name('users.create');
    Route::post('/users', [\App\Http\Controllers\AdminUserController::class, 'store'])->name('users.store');
    Route::get('/users/{id}/edit', [\App\Http\Controllers\AdminUserController::class, 'edit'])->name('users.edit');
    Route::put('/users/{id}', [\App\Http\Controllers\AdminUserController::class, 'update'])->name('users.update');
    Route::delete('/users/{id}', [\App\Http\Controllers\AdminUserController::class, 'destroy'])->name('users.delete');
    Route::post('/users/{id}/toggle-status', [\App\Http\Controllers\AdminUserController::class, 'toggleStatus'])->name('users.toggle-status');
    
    Route::get('/settings', [\App\Http\Controllers\AdminSettingsController::class, 'index'])->name('settings');
    Route::put('/settings', [\App\Http\Controllers\AdminSettingsController::class, 'update'])->name('settings.update');
    
    Route::get('/prescriptions', [AdminController::class, 'prescriptions'])->name('prescriptions');
    Route::delete('/prescriptions/{id}', [AdminController::class, 'deletePrescription'])->name('prescriptions.delete');
    Route::get('/appointments', [AdminController::class, 'appointments'])->name('appointments');
    Route::get('/patients', [AdminController::class, 'patients'])->name('patients');
    
    Route::get('/notifications', [AdminController::class, 'notifications'])->name('notifications');
    Route::post('/notifications/{id}/mark-read', [AdminController::class, 'markNotificationRead'])->name('notifications.mark-read');
    Route::post('/notifications/mark-all-read', [AdminController::class, 'markAllNotificationsRead'])->name('notifications.mark-all-read');
    
    // Reports Routes
    Route::get('/reports', [\App\Http\Controllers\ReportsController::class, 'index'])->name('reports.index');
    Route::get('/reports/prescriptions', [\App\Http\Controllers\ReportsController::class, 'prescriptions'])->name('reports.prescriptions');
    Route::get('/reports/doctors', [\App\Http\Controllers\ReportsController::class, 'doctors'])->name('reports.doctors');
    Route::get('/reports/patients', [\App\Http\Controllers\ReportsController::class, 'patients'])->name('reports.patients');
    Route::get('/reports/appointments', [\App\Http\Controllers\ReportsController::class, 'appointments'])->name('reports.appointments');
    Route::get('/reports/overview', [\App\Http\Controllers\ReportsController::class, 'overview'])->name('reports.overview');
    Route::get('/reports/export-prescriptions', [\App\Http\Controllers\ReportsController::class, 'exportPrescriptions'])->name('reports.export-prescriptions');
});

// Doctor Routes
Route::middleware(['auth', 'doctor'])->prefix('doctor')->name('doctor.')->group(function () {
    Route::get('/dashboard', [DoctorController::class, 'dashboard'])->name('dashboard');
    Route::get('/profile', [DoctorController::class, 'profile'])->name('profile');
    Route::put('/profile', [DoctorController::class, 'updateProfile'])->name('profile.update');
    Route::get('/availability', [DoctorController::class, 'availability'])->name('availability');
    Route::post('/availability', [DoctorController::class, 'storeAvailability'])->name('availability.store');
    Route::delete('/availability/{id}', [DoctorController::class, 'deleteAvailability'])->name('availability.delete');
    Route::get('/appointments', [DoctorController::class, 'appointments'])->name('appointments');
    Route::get('/prescriptions', [DoctorController::class, 'prescriptions'])->name('prescriptions');
    Route::get('/video-call/{id}', [DoctorController::class, 'videoCall'])->name('video-call');
    Route::get('/notifications', [DoctorController::class, 'notifications'])->name('notifications');
    Route::post('/notifications/{id}/mark-read', [DoctorController::class, 'markNotificationRead'])->name('notifications.mark-read');
    Route::post('/notifications/mark-all-read', [DoctorController::class, 'markAllNotificationsRead'])->name('notifications.mark-all-read');
});

// Pharmacist Routes
Route::middleware(['auth', 'pharmacist'])->prefix('pharmacist')->name('pharmacist.')->group(function () {
    Route::get('/dashboard', [PharmacistController::class, 'dashboard'])->name('dashboard');
    Route::get('/appointments/create', [PharmacistController::class, 'createAppointment'])->name('appointments.create');
    Route::post('/appointments', [PharmacistController::class, 'storeAppointment'])->name('appointments.store');
    Route::get('/appointments', [PharmacistController::class, 'appointments'])->name('appointments');
    Route::get('/prescriptions', [PharmacistController::class, 'prescriptions'])->name('prescriptions');
    Route::get('/video-call/{id}', [PharmacistController::class, 'videoCall'])->name('video-call');
    Route::get('/doctor-availability/{doctorId}', [PharmacistController::class, 'getDoctorAvailability'])->name('doctor-availability');
    Route::get('/notifications', [PharmacistController::class, 'notifications'])->name('notifications');
    Route::post('/notifications/{id}/mark-read', [PharmacistController::class, 'markNotificationRead'])->name('notifications.mark-read');
    Route::post('/notifications/mark-all-read', [PharmacistController::class, 'markAllNotificationsRead'])->name('notifications.mark-all-read');
});

// Patient Routes
Route::middleware(['auth', 'patient'])->prefix('patient')->name('patient.')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\PatientController::class, 'dashboard'])->name('dashboard');
    Route::get('/prescriptions', [\App\Http\Controllers\PatientController::class, 'prescriptions'])->name('prescriptions');
    Route::get('/appointments', [\App\Http\Controllers\PatientController::class, 'appointments'])->name('appointments');
});

// Prescription Routes (accessible by doctors and patients)
Route::middleware(['auth'])->prefix('prescriptions')->name('prescriptions.')->group(function () {
    Route::get('/create/{appointmentId}', [PrescriptionController::class, 'create'])->middleware('doctor')->name('create');
    Route::post('/store/{appointmentId}', [PrescriptionController::class, 'store'])->middleware('doctor')->name('store');
    Route::get('/{id}', [PrescriptionController::class, 'show'])->name('show');
    Route::get('/{id}/download', [PrescriptionController::class, 'download'])->name('download');
});

